import java.io.*;
import java.util.*;
import java.math.*;

public class I implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	private void solve() throws IOException {
		int n = nextInt();
		int[][] initG = new int[n][n];
		final int maxEdges = 100000;
		int[] edgeFrom = new int[maxEdges];
		int[] edgeTo = new int[maxEdges];
		int totalEdges = 0;
		for (int u = 0; u < n; u++) {
			Arrays.fill(initG[u], -1);
			int m = nextInt();
			for (int j = 0; j < m; j++) {
				int v = nextInt() - 1;
				initG[u][v] = totalEdges;
				edgeFrom[totalEdges] = u;
				edgeTo[totalEdges] = v;
				++totalEdges;
			}
		}
		boolean[][] resultG = new boolean[totalEdges][totalEdges];
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				for (int k = 0; k < n; k++) {
					if (i != j && j != k && i != k && initG[i][j] != -1
							&& initG[j][k] != -1) {
						resultG[initG[i][j]][initG[j][k]] = true;
					}
				}
			}
		}
		int[] mt = new int[totalEdges];
		boolean[] used = new boolean[totalEdges];
		Arrays.fill(mt, -1);
		for (int i = 0; i < totalEdges; i++) {
			Arrays.fill(used, false);
			dfs(i, resultG, mt, used);
		}
		List<List<Integer>> pathes = new ArrayList<List<Integer>>();
		Arrays.fill(used, false);
		int[] powsIn = new int[totalEdges];
		for (int i = 0; i < totalEdges; i++) {
			if (mt[i] != -1)
				++powsIn[mt[i]];
		}
		for (int i = 0; i < totalEdges; i++) {
			if (powsIn[i] == 0) {
				List<Integer> newPath = new ArrayList<>();
				int j = i;
				while (j != -1) {
					newPath.add(j);
					j = mt[j];
				}
				Collections.reverse(newPath);

				List<Integer> edgePath = new ArrayList<>();
				int firstId = newPath.get(0);
				int u = edgeFrom[firstId], v = edgeTo[firstId];
				//out.println("FirstId: " + firstId + " " + totalEdges);
				edgePath.add(u + 1);
				edgePath.add(v + 1);
				for (j = 1; j < newPath.size(); j++) {
					int currentId = newPath.get(j);
					v = edgeTo[currentId];
					edgePath.add(v + 1);
				}

				pathes.add(edgePath);
			}
		}
		out.println(pathes.size());
		for (List<Integer> path : pathes) {
			for (int i : path) {
				out.print(i + " ");
			}
			out.println();
		}
	}

	private boolean dfs(int u, boolean[][] g, int[] mt, boolean[] used) {
		if (used[u])
			return false;
		used[u] = true;
		for (int v = 0; v < g[u].length; v++) {
			if (g[u][v]) {
				if (mt[v] == -1 || dfs(mt[v], g, mt, used)) {
					mt[v] = u;
					return true;
				}
			}
		}
		return false;
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new I().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
